; NCL file created by ./ctl2ncl.rb

; Longitude co-ordinate
; ................
  nlon=144
  lon=fspan(-180.0,177.5,144)
  lon!0="lon"
  lon&lon=lon
  lon@units="degrees_east"
  lon@long_name="Longitude"
  printVarSummary(lon)

; Latitude co-ordinate
; ................
  nlat=91
  lat=fspan(-90.0,90.0,91)
  lat!0="lat"
  lat&lat=lat
  lat@units="degrees_north"
  lat@long_name="Latitude"
  printVarSummary(lat)

; Z co-ordinate
; ................
  nlev=20
  lev=(/1000,975,950,925,900,850,800,750,700,650,600,550,500,450,400,350,300,250,200,150/)
  lev!0="lev"
  lev&lev=lev
  lev@units="m" ; this is for GrADs
  lev@long_name="z-levels"
  lev@original_units = "unknown ... please fill in"
  printVarSummary(lev)

; T co-ordinate
; ................
  ntim=1
  time=fspan(0.5,0.5,ntim)
  time!0="time"
  time&time=time
  time@units="months since 2000-1-1 0:0"
  time@long_name="time"
  printVarSummary(time)

; Open the binary data file
;  Please fill this up yourselves
;  setfileoption("bin","ReadByteOrder","endianness")
;fout=addfile("ndvi.nc","c")
  path="./2004_AVHRR_VEGTYPE.bin"
  rec_dims=(/nlat,nlon/)
  rec_type="float"

      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  ireg=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*41
    rec_num=rec_num+0
    do il=0,nens-1
      ireg(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  ireg@units="fields(C)"      
  ireg@long_name="** NOAA OI.v2 SST monthly"      
  ireg!0="time"
  ireg!1="lev"
  ireg!2="lat"
  ireg!3="lon"
  ireg&lon=lon
  ireg&lat=lat
  ireg&lev=lev(:nens-1)
  ireg&time=tim2
  ireg@_FillValue=-999.0
  ireg@missing_value=-999.0
      
;fout->ireg=ireg(:,0,:,:)
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=20      
  iland=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*41
    rec_num=rec_num+1
    do il=0,nens-1
      iland(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  iland@units="fields(C)"      
  iland@long_name="** NOAA OI.v2 SST monthly"      
  iland!0="time"
  iland!1="lev"
  iland!2="lat"
  iland!3="lon"
  iland&lon=lon
  iland&lat=lat
  iland&lev=lev(:nens-1)
  iland&time=tim2
  iland@_FillValue=-999.0
  iland@missing_value=-999.0
      
;fout->iland=iland
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=20      
  iuse=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*41
    rec_num=rec_num+21
    do il=0,nens-1
      iuse(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  iuse@units="fields(C)"      
  iuse@long_name="** NOAA OI.v2 SST monthly"      
  iuse!0="time"
  iuse!1="lev"
  iuse!2="lat"
  iuse!3="lon"
  iuse&lon=lon
  iuse&lat=lat
  iuse&lev=lev(:nens-1)
  iuse&time=tim2
  iuse@_FillValue=-999.0
  iuse@missing_value=-999.0
      
;fout->iuse=iuse
